// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDriveItemValidatePermissionRequest;
import com.microsoft.graph.requests.extensions.DriveItemValidatePermissionRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Validate Permission Request Builder.
 */
public class DriveItemValidatePermissionRequestBuilder extends BaseActionRequestBuilder implements IDriveItemValidatePermissionRequestBuilder {

    /**
     * The request builder for this DriveItemValidatePermission
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param challengeToken the challengeToken
     * @param password the password
     */
    public DriveItemValidatePermissionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String challengeToken, final String password) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("challengeToken", challengeToken);
        bodyParams.put("password", password);
    }

    /**
     * Creates the IDriveItemValidatePermissionRequest
     *
     * @return the IDriveItemValidatePermissionRequest instance
     */
    public IDriveItemValidatePermissionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDriveItemValidatePermissionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IDriveItemValidatePermissionRequest instance
     */
    public IDriveItemValidatePermissionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        DriveItemValidatePermissionRequest request = new DriveItemValidatePermissionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("challengeToken")) {
            request.body.challengeToken = getParameter("challengeToken");
        }

        if (hasParameter("password")) {
            request.body.password = getParameter("password");
        }

        return request;
    }
}
