// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDriveItemCheckinRequest;
import com.microsoft.graph.requests.extensions.DriveItemCheckinRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Checkin Request Builder.
 */
public class DriveItemCheckinRequestBuilder extends BaseActionRequestBuilder implements IDriveItemCheckinRequestBuilder {

    /**
     * The request builder for this DriveItemCheckin
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param checkInAs the checkInAs
     * @param comment the comment
     */
    public DriveItemCheckinRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String checkInAs, final String comment) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("checkInAs", checkInAs);
        bodyParams.put("comment", comment);
    }

    /**
     * Creates the IDriveItemCheckinRequest
     *
     * @return the IDriveItemCheckinRequest instance
     */
    public IDriveItemCheckinRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDriveItemCheckinRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IDriveItemCheckinRequest instance
     */
    public IDriveItemCheckinRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        DriveItemCheckinRequest request = new DriveItemCheckinRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("checkInAs")) {
            request.body.checkInAs = getParameter("checkInAs");
        }

        if (hasParameter("comment")) {
            request.body.comment = getParameter("comment");
        }

        return request;
    }
}
