// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDomainVerifyRequest;
import com.microsoft.graph.requests.extensions.DomainVerifyRequest;
import com.microsoft.graph.models.extensions.Domain;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Verify Request Builder.
 */
public class DomainVerifyRequestBuilder extends BaseActionRequestBuilder implements IDomainVerifyRequestBuilder {

    /**
     * The request builder for this DomainVerify
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DomainVerifyRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IDomainVerifyRequest
     *
     * @return the IDomainVerifyRequest instance
     */
    public IDomainVerifyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDomainVerifyRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IDomainVerifyRequest instance
     */
    public IDomainVerifyRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        DomainVerifyRequest request = new DomainVerifyRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
