/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class SiteWithReferenceRequest
extends BaseRequest
implements ISiteWithReferenceRequest {
    public SiteWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Site.class);
    }

    @Override
    public void post(Site newSite, IJsonBackedObject payload, ICallback<Site> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public Site post(Site newSite, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newSite;
        }
        return null;
    }

    @Override
    public void get(ICallback<Site> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Site get() throws ClientException {
        return (Site)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Site> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Site sourceSite, ICallback<Site> callback) {
        this.send(HttpMethod.PATCH, callback, sourceSite);
    }

    @Override
    public Site patch(Site sourceSite) throws ClientException {
        return (Site)this.send(HttpMethod.PATCH, sourceSite);
    }

    @Override
    public ISiteWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

