/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ResourceOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IResourceOperationRequest;
import java.util.List;

public class ResourceOperationRequest
extends BaseRequest
implements IResourceOperationRequest {
    public ResourceOperationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResourceOperation.class);
    }

    @Override
    public void get(ICallback<ResourceOperation> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ResourceOperation get() throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ResourceOperation> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ResourceOperation sourceResourceOperation, ICallback<ResourceOperation> callback) {
        this.send(HttpMethod.PATCH, callback, sourceResourceOperation);
    }

    @Override
    public ResourceOperation patch(ResourceOperation sourceResourceOperation) throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.PATCH, sourceResourceOperation);
    }

    @Override
    public void post(ResourceOperation newResourceOperation, ICallback<ResourceOperation> callback) {
        this.send(HttpMethod.POST, callback, newResourceOperation);
    }

    @Override
    public ResourceOperation post(ResourceOperation newResourceOperation) throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.POST, newResourceOperation);
    }

    @Override
    public IResourceOperationRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IResourceOperationRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

