/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.callrecords.requests.extensions;

import com.microsoft.graph.callrecords.models.extensions.Session;
import com.microsoft.graph.callrecords.requests.extensions.ISessionCollectionPage;
import com.microsoft.graph.callrecords.requests.extensions.ISessionCollectionRequest;
import com.microsoft.graph.callrecords.requests.extensions.SessionCollectionPage;
import com.microsoft.graph.callrecords.requests.extensions.SessionCollectionRequestBuilder;
import com.microsoft.graph.callrecords.requests.extensions.SessionCollectionResponse;
import com.microsoft.graph.callrecords.requests.extensions.SessionRequestBuilder;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class SessionCollectionRequest
extends BaseCollectionRequest<SessionCollectionResponse, ISessionCollectionPage>
implements ISessionCollectionRequest {
    public SessionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SessionCollectionResponse.class, ISessionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISessionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SessionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISessionCollectionPage get() throws ClientException {
        SessionCollectionResponse response = (SessionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Session newSession, ICallback<Session> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SessionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSession, callback);
    }

    @Override
    public Session post(Session newSession) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SessionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSession);
    }

    @Override
    public ISessionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISessionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISessionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISessionCollectionPage buildFromResponse(SessionCollectionResponse response) {
        SessionCollectionRequestBuilder builder = response.nextLink != null ? new SessionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SessionCollectionPage page = new SessionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

