// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookWorksheet;
import com.microsoft.graph.models.extensions.WorkbookTable;
import com.microsoft.graph.models.extensions.WorkbookRange;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IWorkbookTableRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableCollectionRequest;
import com.microsoft.graph.requests.extensions.IWorkbookTableAddRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableItemAtRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableCountRequestBuilder;
import com.microsoft.graph.http.IBaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Table Collection Request Builder.
 */
public interface IWorkbookTableCollectionRequestBuilder extends IRequestBuilder {

    IWorkbookTableCollectionRequest buildRequest();

    IWorkbookTableCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);

    IWorkbookTableRequestBuilder byId(final String id);

    IWorkbookTableAddRequestBuilder add(final String address, final Boolean hasHeaders);
    IWorkbookTableItemAtRequestBuilder itemAt(final Integer index);
    IWorkbookTableCountRequestBuilder count();
}
