// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookFunctions;
import com.microsoft.graph.models.extensions.WorkbookFunctionResult;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Functions Request Builder.
 */
public interface IWorkbookFunctionsRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IWorkbookFunctionsRequest instance
     */
    IWorkbookFunctionsRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookFunctionsRequest instance
     */
    IWorkbookFunctionsRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);

    IWorkbookFunctionsAbsRequestBuilder abs(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAccrIntRequestBuilder accrInt(final com.google.gson.JsonElement issue, final com.google.gson.JsonElement firstInterest, final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement par, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis, final com.google.gson.JsonElement calcMethod);
    IWorkbookFunctionsAccrIntMRequestBuilder accrIntM(final com.google.gson.JsonElement issue, final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement par, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsAcosRequestBuilder acos(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAcoshRequestBuilder acosh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAcotRequestBuilder acot(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAcothRequestBuilder acoth(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAmorDegrcRequestBuilder amorDegrc(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement datePurchased, final com.google.gson.JsonElement firstPeriod, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement period, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsAmorLincRequestBuilder amorLinc(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement datePurchased, final com.google.gson.JsonElement firstPeriod, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement period, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsAndRequestBuilder and(final com.google.gson.JsonElement values);
    IWorkbookFunctionsArabicRequestBuilder arabic(final com.google.gson.JsonElement text);
    IWorkbookFunctionsAreasRequestBuilder areas(final com.google.gson.JsonElement reference);
    IWorkbookFunctionsAscRequestBuilder asc(final com.google.gson.JsonElement text);
    IWorkbookFunctionsAsinRequestBuilder asin(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAsinhRequestBuilder asinh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAtanRequestBuilder atan(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAtan2RequestBuilder atan2(final com.google.gson.JsonElement xNum, final com.google.gson.JsonElement yNum);
    IWorkbookFunctionsAtanhRequestBuilder atanh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsAveDevRequestBuilder aveDev(final com.google.gson.JsonElement values);
    IWorkbookFunctionsAverageRequestBuilder average(final com.google.gson.JsonElement values);
    IWorkbookFunctionsAverageARequestBuilder averageA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsAverageIfRequestBuilder averageIf(final com.google.gson.JsonElement range, final com.google.gson.JsonElement criteria, final com.google.gson.JsonElement averageRange);
    IWorkbookFunctionsAverageIfsRequestBuilder averageIfs(final com.google.gson.JsonElement averageRange, final com.google.gson.JsonElement values);
    IWorkbookFunctionsBahtTextRequestBuilder bahtText(final com.google.gson.JsonElement number);
    IWorkbookFunctionsBaseRequestBuilder base(final com.google.gson.JsonElement number, final com.google.gson.JsonElement radix, final com.google.gson.JsonElement minLength);
    IWorkbookFunctionsBesselIRequestBuilder besselI(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBesselJRequestBuilder besselJ(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBesselKRequestBuilder besselK(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBesselYRequestBuilder besselY(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n);
    IWorkbookFunctionsBeta_DistRequestBuilder beta_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement cumulative, final com.google.gson.JsonElement a, final com.google.gson.JsonElement b);
    IWorkbookFunctionsBeta_InvRequestBuilder beta_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement a, final com.google.gson.JsonElement b);
    IWorkbookFunctionsBin2DecRequestBuilder bin2Dec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsBin2HexRequestBuilder bin2Hex(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsBin2OctRequestBuilder bin2Oct(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsBinom_DistRequestBuilder binom_Dist(final com.google.gson.JsonElement numberS, final com.google.gson.JsonElement trials, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsBinom_Dist_RangeRequestBuilder binom_Dist_Range(final com.google.gson.JsonElement trials, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement numberS, final com.google.gson.JsonElement numberS2);
    IWorkbookFunctionsBinom_InvRequestBuilder binom_Inv(final com.google.gson.JsonElement trials, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement alpha);
    IWorkbookFunctionsBitandRequestBuilder bitand(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsBitlshiftRequestBuilder bitlshift(final com.google.gson.JsonElement number, final com.google.gson.JsonElement shiftAmount);
    IWorkbookFunctionsBitorRequestBuilder bitor(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsBitrshiftRequestBuilder bitrshift(final com.google.gson.JsonElement number, final com.google.gson.JsonElement shiftAmount);
    IWorkbookFunctionsBitxorRequestBuilder bitxor(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsCeiling_MathRequestBuilder ceiling_Math(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance, final com.google.gson.JsonElement mode);
    IWorkbookFunctionsCeiling_PreciseRequestBuilder ceiling_Precise(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsCharRequestBuilder msgraphChar(final com.google.gson.JsonElement number);
    IWorkbookFunctionsChiSq_DistRequestBuilder chiSq_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsChiSq_Dist_RTRequestBuilder chiSq_Dist_RT(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsChiSq_InvRequestBuilder chiSq_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsChiSq_Inv_RTRequestBuilder chiSq_Inv_RT(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsChooseRequestBuilder choose(final com.google.gson.JsonElement indexNum, final com.google.gson.JsonElement values);
    IWorkbookFunctionsCleanRequestBuilder clean(final com.google.gson.JsonElement text);
    IWorkbookFunctionsCodeRequestBuilder code(final com.google.gson.JsonElement text);
    IWorkbookFunctionsColumnsRequestBuilder columns(final com.google.gson.JsonElement array);
    IWorkbookFunctionsCombinRequestBuilder combin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsCombinaRequestBuilder combina(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsComplexRequestBuilder complex(final com.google.gson.JsonElement realNum, final com.google.gson.JsonElement iNum, final com.google.gson.JsonElement suffix);
    IWorkbookFunctionsConcatenateRequestBuilder concatenate(final com.google.gson.JsonElement values);
    IWorkbookFunctionsConfidence_NormRequestBuilder confidence_Norm(final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement size);
    IWorkbookFunctionsConfidence_TRequestBuilder confidence_T(final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement size);
    IWorkbookFunctionsConvertRequestBuilder convert(final com.google.gson.JsonElement number, final com.google.gson.JsonElement fromUnit, final com.google.gson.JsonElement toUnit);
    IWorkbookFunctionsCosRequestBuilder cos(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCoshRequestBuilder cosh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCotRequestBuilder cot(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCothRequestBuilder coth(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCountRequestBuilder count(final com.google.gson.JsonElement values);
    IWorkbookFunctionsCountARequestBuilder countA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsCountBlankRequestBuilder countBlank(final com.google.gson.JsonElement range);
    IWorkbookFunctionsCountIfRequestBuilder countIf(final com.google.gson.JsonElement range, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsCountIfsRequestBuilder countIfs(final com.google.gson.JsonElement values);
    IWorkbookFunctionsCoupDayBsRequestBuilder coupDayBs(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupDaysRequestBuilder coupDays(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupDaysNcRequestBuilder coupDaysNc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupNcdRequestBuilder coupNcd(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupNumRequestBuilder coupNum(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCoupPcdRequestBuilder coupPcd(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsCscRequestBuilder csc(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCschRequestBuilder csch(final com.google.gson.JsonElement number);
    IWorkbookFunctionsCumIPmtRequestBuilder cumIPmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement startPeriod, final com.google.gson.JsonElement endPeriod, final com.google.gson.JsonElement type);
    IWorkbookFunctionsCumPrincRequestBuilder cumPrinc(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement startPeriod, final com.google.gson.JsonElement endPeriod, final com.google.gson.JsonElement type);
    IWorkbookFunctionsDaverageRequestBuilder daverage(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDcountRequestBuilder dcount(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDcountARequestBuilder dcountA(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDgetRequestBuilder dget(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDmaxRequestBuilder dmax(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDminRequestBuilder dmin(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDproductRequestBuilder dproduct(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDstDevRequestBuilder dstDev(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDstDevPRequestBuilder dstDevP(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDsumRequestBuilder dsum(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDvarRequestBuilder dvar(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDvarPRequestBuilder dvarP(final com.google.gson.JsonElement database, final com.google.gson.JsonElement field, final com.google.gson.JsonElement criteria);
    IWorkbookFunctionsDateRequestBuilder date(final com.google.gson.JsonElement year, final com.google.gson.JsonElement month, final com.google.gson.JsonElement day);
    IWorkbookFunctionsDatevalueRequestBuilder datevalue(final com.google.gson.JsonElement dateText);
    IWorkbookFunctionsDayRequestBuilder day(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsDaysRequestBuilder days(final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement startDate);
    IWorkbookFunctionsDays360RequestBuilder days360(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement method);
    IWorkbookFunctionsDbRequestBuilder db(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement period, final com.google.gson.JsonElement month);
    IWorkbookFunctionsDbcsRequestBuilder dbcs(final com.google.gson.JsonElement text);
    IWorkbookFunctionsDdbRequestBuilder ddb(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement period, final com.google.gson.JsonElement factor);
    IWorkbookFunctionsDec2BinRequestBuilder dec2Bin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsDec2HexRequestBuilder dec2Hex(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsDec2OctRequestBuilder dec2Oct(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsDecimalRequestBuilder decimal(final com.google.gson.JsonElement number, final com.google.gson.JsonElement radix);
    IWorkbookFunctionsDegreesRequestBuilder degrees(final com.google.gson.JsonElement angle);
    IWorkbookFunctionsDeltaRequestBuilder delta(final com.google.gson.JsonElement number1, final com.google.gson.JsonElement number2);
    IWorkbookFunctionsDevSqRequestBuilder devSq(final com.google.gson.JsonElement values);
    IWorkbookFunctionsDiscRequestBuilder disc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsDollarRequestBuilder dollar(final com.google.gson.JsonElement number, final com.google.gson.JsonElement decimals);
    IWorkbookFunctionsDollarDeRequestBuilder dollarDe(final com.google.gson.JsonElement fractionalDollar, final com.google.gson.JsonElement fraction);
    IWorkbookFunctionsDollarFrRequestBuilder dollarFr(final com.google.gson.JsonElement decimalDollar, final com.google.gson.JsonElement fraction);
    IWorkbookFunctionsDurationRequestBuilder duration(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement coupon, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsEcma_CeilingRequestBuilder ecma_Ceiling(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsEdateRequestBuilder edate(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement months);
    IWorkbookFunctionsEffectRequestBuilder effect(final com.google.gson.JsonElement nominalRate, final com.google.gson.JsonElement npery);
    IWorkbookFunctionsEoMonthRequestBuilder eoMonth(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement months);
    IWorkbookFunctionsErfRequestBuilder erf(final com.google.gson.JsonElement lowerLimit, final com.google.gson.JsonElement upperLimit);
    IWorkbookFunctionsErfCRequestBuilder erfC(final com.google.gson.JsonElement x);
    IWorkbookFunctionsErfC_PreciseRequestBuilder erfC_Precise(final com.google.gson.JsonElement x);
    IWorkbookFunctionsErf_PreciseRequestBuilder erf_Precise(final com.google.gson.JsonElement x);
    IWorkbookFunctionsError_TypeRequestBuilder error_Type(final com.google.gson.JsonElement errorVal);
    IWorkbookFunctionsEvenRequestBuilder even(final com.google.gson.JsonElement number);
    IWorkbookFunctionsExactRequestBuilder exact(final com.google.gson.JsonElement text1, final com.google.gson.JsonElement text2);
    IWorkbookFunctionsExpRequestBuilder exp(final com.google.gson.JsonElement number);
    IWorkbookFunctionsExpon_DistRequestBuilder expon_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement lambda, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsFvscheduleRequestBuilder fvschedule(final com.google.gson.JsonElement principal, final com.google.gson.JsonElement schedule);
    IWorkbookFunctionsF_DistRequestBuilder f_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsF_Dist_RTRequestBuilder f_Dist_RT(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2);
    IWorkbookFunctionsF_InvRequestBuilder f_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2);
    IWorkbookFunctionsF_Inv_RTRequestBuilder f_Inv_RT(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom1, final com.google.gson.JsonElement degFreedom2);
    IWorkbookFunctionsFactRequestBuilder fact(final com.google.gson.JsonElement number);
    IWorkbookFunctionsFactDoubleRequestBuilder factDouble(final com.google.gson.JsonElement number);
    IWorkbookFunctionsFalseRequestBuilder msgraphFalse();
    IWorkbookFunctionsFindRequestBuilder find(final com.google.gson.JsonElement findText, final com.google.gson.JsonElement withinText, final com.google.gson.JsonElement startNum);
    IWorkbookFunctionsFindBRequestBuilder findB(final com.google.gson.JsonElement findText, final com.google.gson.JsonElement withinText, final com.google.gson.JsonElement startNum);
    IWorkbookFunctionsFisherRequestBuilder fisher(final com.google.gson.JsonElement x);
    IWorkbookFunctionsFisherInvRequestBuilder fisherInv(final com.google.gson.JsonElement y);
    IWorkbookFunctionsFixedRequestBuilder fixed(final com.google.gson.JsonElement number, final com.google.gson.JsonElement decimals, final com.google.gson.JsonElement noCommas);
    IWorkbookFunctionsFloor_MathRequestBuilder floor_Math(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance, final com.google.gson.JsonElement mode);
    IWorkbookFunctionsFloor_PreciseRequestBuilder floor_Precise(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsFvRequestBuilder fv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsGammaRequestBuilder gamma(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGammaLnRequestBuilder gammaLn(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGammaLn_PreciseRequestBuilder gammaLn_Precise(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGamma_DistRequestBuilder gamma_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsGamma_InvRequestBuilder gamma_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta);
    IWorkbookFunctionsGaussRequestBuilder gauss(final com.google.gson.JsonElement x);
    IWorkbookFunctionsGcdRequestBuilder gcd(final com.google.gson.JsonElement values);
    IWorkbookFunctionsGeStepRequestBuilder geStep(final com.google.gson.JsonElement number, final com.google.gson.JsonElement step);
    IWorkbookFunctionsGeoMeanRequestBuilder geoMean(final com.google.gson.JsonElement values);
    IWorkbookFunctionsHlookupRequestBuilder hlookup(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement tableArray, final com.google.gson.JsonElement rowIndexNum, final com.google.gson.JsonElement rangeLookup);
    IWorkbookFunctionsHarMeanRequestBuilder harMean(final com.google.gson.JsonElement values);
    IWorkbookFunctionsHex2BinRequestBuilder hex2Bin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsHex2DecRequestBuilder hex2Dec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsHex2OctRequestBuilder hex2Oct(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsHourRequestBuilder hour(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsHypGeom_DistRequestBuilder hypGeom_Dist(final com.google.gson.JsonElement sampleS, final com.google.gson.JsonElement numberSample, final com.google.gson.JsonElement populationS, final com.google.gson.JsonElement numberPop, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsHyperlinkRequestBuilder hyperlink(final com.google.gson.JsonElement linkLocation, final com.google.gson.JsonElement friendlyName);
    IWorkbookFunctionsIso_CeilingRequestBuilder iso_Ceiling(final com.google.gson.JsonElement number, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsIfRequestBuilder msgraphIf(final com.google.gson.JsonElement logicalTest, final com.google.gson.JsonElement valueIfTrue, final com.google.gson.JsonElement valueIfFalse);
    IWorkbookFunctionsImAbsRequestBuilder imAbs(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImArgumentRequestBuilder imArgument(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImConjugateRequestBuilder imConjugate(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCosRequestBuilder imCos(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCoshRequestBuilder imCosh(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCotRequestBuilder imCot(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCscRequestBuilder imCsc(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImCschRequestBuilder imCsch(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImDivRequestBuilder imDiv(final com.google.gson.JsonElement inumber1, final com.google.gson.JsonElement inumber2);
    IWorkbookFunctionsImExpRequestBuilder imExp(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImLnRequestBuilder imLn(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImLog10RequestBuilder imLog10(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImLog2RequestBuilder imLog2(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImPowerRequestBuilder imPower(final com.google.gson.JsonElement inumber, final com.google.gson.JsonElement number);
    IWorkbookFunctionsImProductRequestBuilder imProduct(final com.google.gson.JsonElement values);
    IWorkbookFunctionsImRealRequestBuilder imReal(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSecRequestBuilder imSec(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSechRequestBuilder imSech(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSinRequestBuilder imSin(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSinhRequestBuilder imSinh(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSqrtRequestBuilder imSqrt(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImSubRequestBuilder imSub(final com.google.gson.JsonElement inumber1, final com.google.gson.JsonElement inumber2);
    IWorkbookFunctionsImSumRequestBuilder imSum(final com.google.gson.JsonElement values);
    IWorkbookFunctionsImTanRequestBuilder imTan(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsImaginaryRequestBuilder imaginary(final com.google.gson.JsonElement inumber);
    IWorkbookFunctionsIntRequestBuilder msgraphInt(final com.google.gson.JsonElement number);
    IWorkbookFunctionsIntRateRequestBuilder intRate(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement investment, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsIpmtRequestBuilder ipmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement per, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsIrrRequestBuilder irr(final com.google.gson.JsonElement values, final com.google.gson.JsonElement guess);
    IWorkbookFunctionsIsErrRequestBuilder isErr(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsErrorRequestBuilder isError(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsEvenRequestBuilder isEven(final com.google.gson.JsonElement number);
    IWorkbookFunctionsIsFormulaRequestBuilder isFormula(final com.google.gson.JsonElement reference);
    IWorkbookFunctionsIsLogicalRequestBuilder isLogical(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsNARequestBuilder isNA(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsNonTextRequestBuilder isNonText(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsNumberRequestBuilder isNumber(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsOddRequestBuilder isOdd(final com.google.gson.JsonElement number);
    IWorkbookFunctionsIsTextRequestBuilder isText(final com.google.gson.JsonElement value);
    IWorkbookFunctionsIsoWeekNumRequestBuilder isoWeekNum(final com.google.gson.JsonElement date);
    IWorkbookFunctionsIspmtRequestBuilder ispmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement per, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv);
    IWorkbookFunctionsIsrefRequestBuilder isref(final com.google.gson.JsonElement value);
    IWorkbookFunctionsKurtRequestBuilder kurt(final com.google.gson.JsonElement values);
    IWorkbookFunctionsLargeRequestBuilder large(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsLcmRequestBuilder lcm(final com.google.gson.JsonElement values);
    IWorkbookFunctionsLeftRequestBuilder left(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numChars);
    IWorkbookFunctionsLeftbRequestBuilder leftb(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numBytes);
    IWorkbookFunctionsLenRequestBuilder len(final com.google.gson.JsonElement text);
    IWorkbookFunctionsLenbRequestBuilder lenb(final com.google.gson.JsonElement text);
    IWorkbookFunctionsLnRequestBuilder ln(final com.google.gson.JsonElement number);
    IWorkbookFunctionsLogRequestBuilder log(final com.google.gson.JsonElement number, final com.google.gson.JsonElement base);
    IWorkbookFunctionsLog10RequestBuilder log10(final com.google.gson.JsonElement number);
    IWorkbookFunctionsLogNorm_DistRequestBuilder logNorm_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsLogNorm_InvRequestBuilder logNorm_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev);
    IWorkbookFunctionsLookupRequestBuilder lookup(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement lookupVector, final com.google.gson.JsonElement resultVector);
    IWorkbookFunctionsLowerRequestBuilder lower(final com.google.gson.JsonElement text);
    IWorkbookFunctionsMdurationRequestBuilder mduration(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement coupon, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsMirrRequestBuilder mirr(final com.google.gson.JsonElement values, final com.google.gson.JsonElement financeRate, final com.google.gson.JsonElement reinvestRate);
    IWorkbookFunctionsMroundRequestBuilder mround(final com.google.gson.JsonElement number, final com.google.gson.JsonElement multiple);
    IWorkbookFunctionsMatchRequestBuilder match(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement lookupArray, final com.google.gson.JsonElement matchType);
    IWorkbookFunctionsMaxRequestBuilder max(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMaxARequestBuilder maxA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMedianRequestBuilder median(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMidRequestBuilder mid(final com.google.gson.JsonElement text, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numChars);
    IWorkbookFunctionsMidbRequestBuilder midb(final com.google.gson.JsonElement text, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numBytes);
    IWorkbookFunctionsMinRequestBuilder min(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMinARequestBuilder minA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsMinuteRequestBuilder minute(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsModRequestBuilder mod(final com.google.gson.JsonElement number, final com.google.gson.JsonElement divisor);
    IWorkbookFunctionsMonthRequestBuilder month(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsMultiNomialRequestBuilder multiNomial(final com.google.gson.JsonElement values);
    IWorkbookFunctionsNRequestBuilder n(final com.google.gson.JsonElement value);
    IWorkbookFunctionsNperRequestBuilder nper(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsNaRequestBuilder na();
    IWorkbookFunctionsNegBinom_DistRequestBuilder negBinom_Dist(final com.google.gson.JsonElement numberF, final com.google.gson.JsonElement numberS, final com.google.gson.JsonElement probabilityS, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsNetworkDaysRequestBuilder networkDays(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsNetworkDays_IntlRequestBuilder networkDays_Intl(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement weekend, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsNominalRequestBuilder nominal(final com.google.gson.JsonElement effectRate, final com.google.gson.JsonElement npery);
    IWorkbookFunctionsNorm_DistRequestBuilder norm_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsNorm_InvRequestBuilder norm_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev);
    IWorkbookFunctionsNorm_S_DistRequestBuilder norm_S_Dist(final com.google.gson.JsonElement z, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsNorm_S_InvRequestBuilder norm_S_Inv(final com.google.gson.JsonElement probability);
    IWorkbookFunctionsNotRequestBuilder not(final com.google.gson.JsonElement logical);
    IWorkbookFunctionsNowRequestBuilder now();
    IWorkbookFunctionsNpvRequestBuilder npv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement values);
    IWorkbookFunctionsNumberValueRequestBuilder numberValue(final com.google.gson.JsonElement text, final com.google.gson.JsonElement decimalSeparator, final com.google.gson.JsonElement groupSeparator);
    IWorkbookFunctionsOct2BinRequestBuilder oct2Bin(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsOct2DecRequestBuilder oct2Dec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsOct2HexRequestBuilder oct2Hex(final com.google.gson.JsonElement number, final com.google.gson.JsonElement places);
    IWorkbookFunctionsOddRequestBuilder odd(final com.google.gson.JsonElement number);
    IWorkbookFunctionsOddFPriceRequestBuilder oddFPrice(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement firstCoupon, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOddFYieldRequestBuilder oddFYield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement firstCoupon, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOddLPriceRequestBuilder oddLPrice(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement lastInterest, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOddLYieldRequestBuilder oddLYield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement lastInterest, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsOrRequestBuilder or(final com.google.gson.JsonElement values);
    IWorkbookFunctionsPdurationRequestBuilder pduration(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv);
    IWorkbookFunctionsPercentRank_ExcRequestBuilder percentRank_Exc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement x, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsPercentRank_IncRequestBuilder percentRank_Inc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement x, final com.google.gson.JsonElement significance);
    IWorkbookFunctionsPercentile_ExcRequestBuilder percentile_Exc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsPercentile_IncRequestBuilder percentile_Inc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsPermutRequestBuilder permut(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsPermutationaRequestBuilder permutationa(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numberChosen);
    IWorkbookFunctionsPhiRequestBuilder phi(final com.google.gson.JsonElement x);
    IWorkbookFunctionsPiRequestBuilder pi();
    IWorkbookFunctionsPmtRequestBuilder pmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsPoisson_DistRequestBuilder poisson_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsPowerRequestBuilder power(final com.google.gson.JsonElement number, final com.google.gson.JsonElement power);
    IWorkbookFunctionsPpmtRequestBuilder ppmt(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement per, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsPriceRequestBuilder price(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsPriceDiscRequestBuilder priceDisc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement discount, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsPriceMatRequestBuilder priceMat(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement yld, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsProductRequestBuilder product(final com.google.gson.JsonElement values);
    IWorkbookFunctionsProperRequestBuilder proper(final com.google.gson.JsonElement text);
    IWorkbookFunctionsPvRequestBuilder pv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type);
    IWorkbookFunctionsQuartile_ExcRequestBuilder quartile_Exc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement quart);
    IWorkbookFunctionsQuartile_IncRequestBuilder quartile_Inc(final com.google.gson.JsonElement array, final com.google.gson.JsonElement quart);
    IWorkbookFunctionsQuotientRequestBuilder quotient(final com.google.gson.JsonElement numerator, final com.google.gson.JsonElement denominator);
    IWorkbookFunctionsRadiansRequestBuilder radians(final com.google.gson.JsonElement angle);
    IWorkbookFunctionsRandRequestBuilder rand();
    IWorkbookFunctionsRandBetweenRequestBuilder randBetween(final com.google.gson.JsonElement bottom, final com.google.gson.JsonElement top);
    IWorkbookFunctionsRank_AvgRequestBuilder rank_Avg(final com.google.gson.JsonElement number, final com.google.gson.JsonElement ref, final com.google.gson.JsonElement order);
    IWorkbookFunctionsRank_EqRequestBuilder rank_Eq(final com.google.gson.JsonElement number, final com.google.gson.JsonElement ref, final com.google.gson.JsonElement order);
    IWorkbookFunctionsRateRequestBuilder rate(final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type, final com.google.gson.JsonElement guess);
    IWorkbookFunctionsReceivedRequestBuilder received(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement investment, final com.google.gson.JsonElement discount, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsReplaceRequestBuilder replace(final com.google.gson.JsonElement oldText, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numChars, final com.google.gson.JsonElement newText);
    IWorkbookFunctionsReplaceBRequestBuilder replaceB(final com.google.gson.JsonElement oldText, final com.google.gson.JsonElement startNum, final com.google.gson.JsonElement numBytes, final com.google.gson.JsonElement newText);
    IWorkbookFunctionsReptRequestBuilder rept(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numberTimes);
    IWorkbookFunctionsRightRequestBuilder right(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numChars);
    IWorkbookFunctionsRightbRequestBuilder rightb(final com.google.gson.JsonElement text, final com.google.gson.JsonElement numBytes);
    IWorkbookFunctionsRomanRequestBuilder roman(final com.google.gson.JsonElement number, final com.google.gson.JsonElement form);
    IWorkbookFunctionsRoundRequestBuilder round(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsRoundDownRequestBuilder roundDown(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsRoundUpRequestBuilder roundUp(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsRowsRequestBuilder rows(final com.google.gson.JsonElement array);
    IWorkbookFunctionsRriRequestBuilder rri(final com.google.gson.JsonElement nper, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv);
    IWorkbookFunctionsSecRequestBuilder sec(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSechRequestBuilder sech(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSecondRequestBuilder second(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsSeriesSumRequestBuilder seriesSum(final com.google.gson.JsonElement x, final com.google.gson.JsonElement n, final com.google.gson.JsonElement m, final com.google.gson.JsonElement coefficients);
    IWorkbookFunctionsSheetRequestBuilder sheet(final com.google.gson.JsonElement value);
    IWorkbookFunctionsSheetsRequestBuilder sheets(final com.google.gson.JsonElement reference);
    IWorkbookFunctionsSignRequestBuilder sign(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSinRequestBuilder sin(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSinhRequestBuilder sinh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSkewRequestBuilder skew(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSkew_pRequestBuilder skew_p(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSlnRequestBuilder sln(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life);
    IWorkbookFunctionsSmallRequestBuilder small(final com.google.gson.JsonElement array, final com.google.gson.JsonElement k);
    IWorkbookFunctionsSqrtRequestBuilder sqrt(final com.google.gson.JsonElement number);
    IWorkbookFunctionsSqrtPiRequestBuilder sqrtPi(final com.google.gson.JsonElement number);
    IWorkbookFunctionsStDevARequestBuilder stDevA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStDevPARequestBuilder stDevPA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStDev_PRequestBuilder stDev_P(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStDev_SRequestBuilder stDev_S(final com.google.gson.JsonElement values);
    IWorkbookFunctionsStandardizeRequestBuilder standardize(final com.google.gson.JsonElement x, final com.google.gson.JsonElement mean, final com.google.gson.JsonElement standardDev);
    IWorkbookFunctionsSubstituteRequestBuilder substitute(final com.google.gson.JsonElement text, final com.google.gson.JsonElement oldText, final com.google.gson.JsonElement newText, final com.google.gson.JsonElement instanceNum);
    IWorkbookFunctionsSubtotalRequestBuilder subtotal(final com.google.gson.JsonElement functionNum, final com.google.gson.JsonElement values);
    IWorkbookFunctionsSumRequestBuilder sum(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSumIfRequestBuilder sumIf(final com.google.gson.JsonElement range, final com.google.gson.JsonElement criteria, final com.google.gson.JsonElement sumRange);
    IWorkbookFunctionsSumIfsRequestBuilder sumIfs(final com.google.gson.JsonElement sumRange, final com.google.gson.JsonElement values);
    IWorkbookFunctionsSumSqRequestBuilder sumSq(final com.google.gson.JsonElement values);
    IWorkbookFunctionsSydRequestBuilder syd(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement per);
    IWorkbookFunctionsTRequestBuilder t(final com.google.gson.JsonElement value);
    IWorkbookFunctionsTbillEqRequestBuilder tbillEq(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement discount);
    IWorkbookFunctionsTbillPriceRequestBuilder tbillPrice(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement discount);
    IWorkbookFunctionsTbillYieldRequestBuilder tbillYield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement pr);
    IWorkbookFunctionsT_DistRequestBuilder t_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsT_Dist_2TRequestBuilder t_Dist_2T(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsT_Dist_RTRequestBuilder t_Dist_RT(final com.google.gson.JsonElement x, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsT_InvRequestBuilder t_Inv(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsT_Inv_2TRequestBuilder t_Inv_2T(final com.google.gson.JsonElement probability, final com.google.gson.JsonElement degFreedom);
    IWorkbookFunctionsTanRequestBuilder tan(final com.google.gson.JsonElement number);
    IWorkbookFunctionsTanhRequestBuilder tanh(final com.google.gson.JsonElement number);
    IWorkbookFunctionsTextRequestBuilder text(final com.google.gson.JsonElement value, final com.google.gson.JsonElement formatText);
    IWorkbookFunctionsTimeRequestBuilder time(final com.google.gson.JsonElement hour, final com.google.gson.JsonElement minute, final com.google.gson.JsonElement second);
    IWorkbookFunctionsTimevalueRequestBuilder timevalue(final com.google.gson.JsonElement timeText);
    IWorkbookFunctionsTodayRequestBuilder today();
    IWorkbookFunctionsTrimRequestBuilder trim(final com.google.gson.JsonElement text);
    IWorkbookFunctionsTrimMeanRequestBuilder trimMean(final com.google.gson.JsonElement array, final com.google.gson.JsonElement percent);
    IWorkbookFunctionsTrueRequestBuilder msgraphTrue();
    IWorkbookFunctionsTruncRequestBuilder trunc(final com.google.gson.JsonElement number, final com.google.gson.JsonElement numDigits);
    IWorkbookFunctionsTypeRequestBuilder type(final com.google.gson.JsonElement value);
    IWorkbookFunctionsUsdollarRequestBuilder usdollar(final com.google.gson.JsonElement number, final com.google.gson.JsonElement decimals);
    IWorkbookFunctionsUnicharRequestBuilder unichar(final com.google.gson.JsonElement number);
    IWorkbookFunctionsUnicodeRequestBuilder unicode(final com.google.gson.JsonElement text);
    IWorkbookFunctionsUpperRequestBuilder upper(final com.google.gson.JsonElement text);
    IWorkbookFunctionsVlookupRequestBuilder vlookup(final com.google.gson.JsonElement lookupValue, final com.google.gson.JsonElement tableArray, final com.google.gson.JsonElement colIndexNum, final com.google.gson.JsonElement rangeLookup);
    IWorkbookFunctionsValueRequestBuilder value(final com.google.gson.JsonElement text);
    IWorkbookFunctionsVarARequestBuilder varA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVarPARequestBuilder varPA(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVar_PRequestBuilder var_P(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVar_SRequestBuilder var_S(final com.google.gson.JsonElement values);
    IWorkbookFunctionsVdbRequestBuilder vdb(final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement startPeriod, final com.google.gson.JsonElement endPeriod, final com.google.gson.JsonElement factor, final com.google.gson.JsonElement noSwitch);
    IWorkbookFunctionsWeekNumRequestBuilder weekNum(final com.google.gson.JsonElement serialNumber, final com.google.gson.JsonElement returnType);
    IWorkbookFunctionsWeekdayRequestBuilder weekday(final com.google.gson.JsonElement serialNumber, final com.google.gson.JsonElement returnType);
    IWorkbookFunctionsWeibull_DistRequestBuilder weibull_Dist(final com.google.gson.JsonElement x, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement beta, final com.google.gson.JsonElement cumulative);
    IWorkbookFunctionsWorkDayRequestBuilder workDay(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement days, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsWorkDay_IntlRequestBuilder workDay_Intl(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement days, final com.google.gson.JsonElement weekend, final com.google.gson.JsonElement holidays);
    IWorkbookFunctionsXirrRequestBuilder xirr(final com.google.gson.JsonElement values, final com.google.gson.JsonElement dates, final com.google.gson.JsonElement guess);
    IWorkbookFunctionsXnpvRequestBuilder xnpv(final com.google.gson.JsonElement rate, final com.google.gson.JsonElement values, final com.google.gson.JsonElement dates);
    IWorkbookFunctionsXorRequestBuilder xor(final com.google.gson.JsonElement values);
    IWorkbookFunctionsYearRequestBuilder year(final com.google.gson.JsonElement serialNumber);
    IWorkbookFunctionsYearFracRequestBuilder yearFrac(final com.google.gson.JsonElement startDate, final com.google.gson.JsonElement endDate, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsYieldRequestBuilder yield(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement frequency, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsYieldDiscRequestBuilder yieldDisc(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement redemption, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsYieldMatRequestBuilder yieldMat(final com.google.gson.JsonElement settlement, final com.google.gson.JsonElement maturity, final com.google.gson.JsonElement issue, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pr, final com.google.gson.JsonElement basis);
    IWorkbookFunctionsZ_TestRequestBuilder z_Test(final com.google.gson.JsonElement array, final com.google.gson.JsonElement x, final com.google.gson.JsonElement sigma);

}