// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.CancelMediaProcessingOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Cancel Media Processing Operation Request.
 */
public interface ICancelMediaProcessingOperationRequest extends IHttpRequest {

    /**
     * Gets the CancelMediaProcessingOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<CancelMediaProcessingOperation> callback);

    /**
     * Gets the CancelMediaProcessingOperation from the service
     *
     * @return the CancelMediaProcessingOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CancelMediaProcessingOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<CancelMediaProcessingOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this CancelMediaProcessingOperation with a source
     *
     * @param sourceCancelMediaProcessingOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final CancelMediaProcessingOperation sourceCancelMediaProcessingOperation, final ICallback<CancelMediaProcessingOperation> callback);

    /**
     * Patches this CancelMediaProcessingOperation with a source
     *
     * @param sourceCancelMediaProcessingOperation the source object with updates
     * @return the updated CancelMediaProcessingOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CancelMediaProcessingOperation patch(final CancelMediaProcessingOperation sourceCancelMediaProcessingOperation) throws ClientException;

    /**
     * Posts a CancelMediaProcessingOperation with a new object
     *
     * @param newCancelMediaProcessingOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final CancelMediaProcessingOperation newCancelMediaProcessingOperation, final ICallback<CancelMediaProcessingOperation> callback);

    /**
     * Posts a CancelMediaProcessingOperation with a new object
     *
     * @param newCancelMediaProcessingOperation the new object to create
     * @return the created CancelMediaProcessingOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CancelMediaProcessingOperation post(final CancelMediaProcessingOperation newCancelMediaProcessingOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ICancelMediaProcessingOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ICancelMediaProcessingOperationRequest expand(final String value);

}

