// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.InvitedUserMessageInfo;
import com.microsoft.graph.models.extensions.User;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Invitation.
 */
public class Invitation extends Entity implements IJsonBackedObject {


    /**
     * The Invited User Display Name.
     * The display name of the user being invited.
     */
    @SerializedName("invitedUserDisplayName")
    @Expose
    public String invitedUserDisplayName;

    /**
     * The Invited User Type.
     * The userType of the user being invited. By default, this is Guest. You can invite as Member if you are a company administrator.
     */
    @SerializedName("invitedUserType")
    @Expose
    public String invitedUserType;

    /**
     * The Invited User Email Address.
     * The email address of the user being invited. Required. The following special characters are not permitted in the email address:Tilde (~)Exclamation point (!)Number sign (#)Dollar sign ($)Percent (%)Circumflex (^)Ampersand (&amp;)Asterisk (*)Parentheses (( ))Plus sign (+)Equal sign (=)Brackets ([ ])Braces ({ })Backslash (/)Slash mark (/)Pipe (/|)Semicolon (;)Colon (:)Quotation marks (')Angle brackets (&amp;lt; &amp;gt;)Question mark (?)Comma (,)However, the following exceptions apply:A period (.) or a hyphen (-) is permitted anywhere in the user name, except at the beginning or end of the name.An underscore (_) is permitted anywhere in the user name. This includes at the beginning or end of the name.
     */
    @SerializedName("invitedUserEmailAddress")
    @Expose
    public String invitedUserEmailAddress;

    /**
     * The Invited User Message Info.
     * Additional configuration for the message being sent to the invited user, including customizing message text, language and cc recipient list.
     */
    @SerializedName("invitedUserMessageInfo")
    @Expose
    public InvitedUserMessageInfo invitedUserMessageInfo;

    /**
     * The Send Invitation Message.
     * Indicates whether an email should be sent to the user being invited or not. The default is false.
     */
    @SerializedName("sendInvitationMessage")
    @Expose
    public Boolean sendInvitationMessage;

    /**
     * The Invite Redirect Url.
     * The URL user should be redirected to once the invitation is redeemed. Required.
     */
    @SerializedName("inviteRedirectUrl")
    @Expose
    public String inviteRedirectUrl;

    /**
     * The Invite Redeem Url.
     * The URL user can use to redeem his invitation. Read-Only
     */
    @SerializedName("inviteRedeemUrl")
    @Expose
    public String inviteRedeemUrl;

    /**
     * The Status.
     * The status of the invitation. Possible values: PendingAcceptance, Completed, InProgress, and Error
     */
    @SerializedName("status")
    @Expose
    public String status;

    /**
     * The Invited User.
     * The user created as part of the invitation creation. Read-Only
     */
    @SerializedName("invitedUser")
    @Expose
    public User invitedUser;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
