// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.callrecords.models.extensions.NetworkInfo;
import com.microsoft.graph.callrecords.models.extensions.DeviceInfo;
import com.microsoft.graph.callrecords.models.extensions.MediaStream;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Media.
 */
public class Media implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Label.
     * How the media was identified during media negotiation stage.
     */
    @SerializedName("label")
    @Expose
    public String label;

    /**
     * The Caller Network.
     * Network information associated with the caller endpoint of this media.
     */
    @SerializedName("callerNetwork")
    @Expose
    public NetworkInfo callerNetwork;

    /**
     * The Callee Network.
     * Network information associated with the callee endpoint of this media.
     */
    @SerializedName("calleeNetwork")
    @Expose
    public NetworkInfo calleeNetwork;

    /**
     * The Caller Device.
     * Device information associated with the caller endpoint of this media.
     */
    @SerializedName("callerDevice")
    @Expose
    public DeviceInfo callerDevice;

    /**
     * The Callee Device.
     * Device information associated with the callee endpoint of this media.
     */
    @SerializedName("calleeDevice")
    @Expose
    public DeviceInfo calleeDevice;

    /**
     * The Streams.
     * Network streams associated with this media.
     */
    @SerializedName("streams")
    @Expose
    public java.util.List<MediaStream> streams;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
