// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.callrecords.models.generated.CallType;
import com.microsoft.graph.callrecords.models.generated.Modality;
import com.microsoft.graph.models.extensions.IdentitySet;
import com.microsoft.graph.callrecords.models.extensions.Session;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.callrecords.requests.extensions.SessionCollectionResponse;
import com.microsoft.graph.callrecords.requests.extensions.SessionCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Record.
 */
public class CallRecord extends Entity implements IJsonBackedObject {


    /**
     * The Version.
     * Monotonically increasing version of the call record. Higher version call records with the same id includes additional data compared to the lower version.
     */
    @SerializedName("version")
    @Expose
    public Long version;

    /**
     * The Type.
     * Indicates the type of the call. Possible values are: unknown, groupCall, peerToPeer, unknownFutureValue.
     */
    @SerializedName("type")
    @Expose
    public CallType type;

    /**
     * The Modalities.
     * List of all the modalities used in the call. Possible values are: unknown, audio, video, videoBasedScreenSharing, data, screenSharing, unknownFutureValue.
     */
    @SerializedName("modalities")
    @Expose
    public java.util.List<Modality> modalities;

    /**
     * The Last Modified Date Time.
     * UTC time when the call record was created. The DatetimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName("lastModifiedDateTime")
    @Expose
    public java.util.Calendar lastModifiedDateTime;

    /**
     * The Start Date Time.
     * UTC time when the first user joined the call. The DatetimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName("startDateTime")
    @Expose
    public java.util.Calendar startDateTime;

    /**
     * The End Date Time.
     * UTC time when the last user left the call. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName("endDateTime")
    @Expose
    public java.util.Calendar endDateTime;

    /**
     * The Organizer.
     * The organizing party's identity.
     */
    @SerializedName("organizer")
    @Expose
    public IdentitySet organizer;

    /**
     * The Participants.
     * List of distinct identities involved in the call.
     */
    @SerializedName("participants")
    @Expose
    public java.util.List<IdentitySet> participants;

    /**
     * The Join Web Url.
     * Meeting URL associated to the call. May not be available for a peerToPeer call record type.
     */
    @SerializedName("joinWebUrl")
    @Expose
    public String joinWebUrl;

    /**
     * The Sessions.
     * List of sessions involved in the call. Peer-to-peer calls typically only have one session, whereas group calls typically have at least one session per participant. Read-only. Nullable.
     */
    public SessionCollectionPage sessions;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("sessions")) {
            final SessionCollectionResponse response = new SessionCollectionResponse();
            if (json.has("sessions@odata.nextLink")) {
                response.nextLink = json.get("sessions@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("sessions").toString(), JsonObject[].class);
            final Session[] array = new Session[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Session.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            sessions = new SessionCollectionPage(response, null);
        }
    }
}
