/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITokenLifetimePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ITokenLifetimePolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ITokenLifetimePolicyCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.TokenLifetimePolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.TokenLifetimePolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.TokenLifetimePolicyCollectionWithReferencesRequestBuilder;
import java.util.List;

public class TokenLifetimePolicyCollectionWithReferencesRequest
extends BaseCollectionRequest<TokenLifetimePolicyCollectionResponse, ITokenLifetimePolicyCollectionPage>
implements ITokenLifetimePolicyCollectionWithReferencesRequest {
    public TokenLifetimePolicyCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TokenLifetimePolicyCollectionResponse.class, ITokenLifetimePolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITokenLifetimePolicyCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TokenLifetimePolicyCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITokenLifetimePolicyCollectionWithReferencesPage get() throws ClientException {
        TokenLifetimePolicyCollectionResponse response = (TokenLifetimePolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public ITokenLifetimePolicyCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITokenLifetimePolicyCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITokenLifetimePolicyCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ITokenLifetimePolicyCollectionWithReferencesPage buildFromResponse(TokenLifetimePolicyCollectionResponse response) {
        TokenLifetimePolicyCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new TokenLifetimePolicyCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TokenLifetimePolicyCollectionWithReferencesPage page = new TokenLifetimePolicyCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

