/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.TeamsApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsAppWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class TeamsAppWithReferenceRequest
extends BaseRequest
implements ITeamsAppWithReferenceRequest {
    public TeamsAppWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsApp.class);
    }

    @Override
    public void post(TeamsApp newTeamsApp, IJsonBackedObject payload, ICallback<TeamsApp> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public TeamsApp post(TeamsApp newTeamsApp, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newTeamsApp;
        }
        return null;
    }

    @Override
    public void get(ICallback<TeamsApp> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public TeamsApp get() throws ClientException {
        return (TeamsApp)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<TeamsApp> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(TeamsApp sourceTeamsApp, ICallback<TeamsApp> callback) {
        this.send(HttpMethod.PATCH, callback, sourceTeamsApp);
    }

    @Override
    public TeamsApp patch(TeamsApp sourceTeamsApp) throws ClientException {
        return (TeamsApp)this.send(HttpMethod.PATCH, sourceTeamsApp);
    }

    @Override
    public ITeamsAppWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsAppWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

