/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OfferShiftRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOfferShiftRequestCollectionPage;
import com.microsoft.graph.requests.extensions.IOfferShiftRequestCollectionRequest;
import com.microsoft.graph.requests.extensions.OfferShiftRequestCollectionPage;
import com.microsoft.graph.requests.extensions.OfferShiftRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OfferShiftRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.OfferShiftRequestRequestBuilder;
import java.util.List;

public class OfferShiftRequestCollectionRequest
extends BaseCollectionRequest<OfferShiftRequestCollectionResponse, IOfferShiftRequestCollectionPage>
implements IOfferShiftRequestCollectionRequest {
    public OfferShiftRequestCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OfferShiftRequestCollectionResponse.class, IOfferShiftRequestCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOfferShiftRequestCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OfferShiftRequestCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOfferShiftRequestCollectionPage get() throws ClientException {
        OfferShiftRequestCollectionResponse response = (OfferShiftRequestCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OfferShiftRequest newOfferShiftRequest, ICallback<OfferShiftRequest> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OfferShiftRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOfferShiftRequest, callback);
    }

    @Override
    public OfferShiftRequest post(OfferShiftRequest newOfferShiftRequest) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OfferShiftRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOfferShiftRequest);
    }

    @Override
    public IOfferShiftRequestCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOfferShiftRequestCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOfferShiftRequestCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IOfferShiftRequestCollectionPage buildFromResponse(OfferShiftRequestCollectionResponse response) {
        OfferShiftRequestCollectionRequestBuilder builder = response.nextLink != null ? new OfferShiftRequestCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OfferShiftRequestCollectionPage page = new OfferShiftRequestCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

