// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Software Update Status Summary Reference Request.
 */
public class SoftwareUpdateStatusSummaryReferenceRequest extends BaseRequest implements ISoftwareUpdateStatusSummaryReferenceRequest {

    /**
     * The request for the SoftwareUpdateStatusSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SoftwareUpdateStatusSummaryReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SoftwareUpdateStatusSummary.class);
    }

    public void delete(final ICallback<SoftwareUpdateStatusSummary> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public SoftwareUpdateStatusSummary delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ISoftwareUpdateStatusSummaryReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (SoftwareUpdateStatusSummaryReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ISoftwareUpdateStatusSummaryReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (SoftwareUpdateStatusSummaryReferenceRequest)this;
    }
    /**
     * Puts the SoftwareUpdateStatusSummary
     *
     * @param srcSoftwareUpdateStatusSummary the SoftwareUpdateStatusSummary reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(SoftwareUpdateStatusSummary srcSoftwareUpdateStatusSummary, final ICallback<SoftwareUpdateStatusSummary> callback) {
        send(HttpMethod.PUT, callback, srcSoftwareUpdateStatusSummary);
    }

    /**
     * Puts the SoftwareUpdateStatusSummary
     *
     * @param srcSoftwareUpdateStatusSummary the SoftwareUpdateStatusSummary reference to PUT
     * @return the SoftwareUpdateStatusSummary
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public SoftwareUpdateStatusSummary put(SoftwareUpdateStatusSummary srcSoftwareUpdateStatusSummary) throws ClientException {
        return send(HttpMethod.PUT, srcSoftwareUpdateStatusSummary);
    }
}
