// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Category Collection Request.
 */
public class MobileAppCategoryCollectionRequest extends BaseCollectionRequest<MobileAppCategoryCollectionResponse, IMobileAppCategoryCollectionPage> implements IMobileAppCategoryCollectionRequest {

    /**
     * The request builder for this collection of MobileAppCategory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileAppCategoryCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCategoryCollectionResponse.class, IMobileAppCategoryCollectionPage.class);
    }

    public void get(final ICallback<IMobileAppCategoryCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IMobileAppCategoryCollectionPage get() throws ClientException {
        final MobileAppCategoryCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final MobileAppCategory newMobileAppCategory, final ICallback<MobileAppCategory> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new MobileAppCategoryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newMobileAppCategory, callback);
    }

    public MobileAppCategory post(final MobileAppCategory newMobileAppCategory) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new MobileAppCategoryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newMobileAppCategory);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IMobileAppCategoryCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (MobileAppCategoryCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IMobileAppCategoryCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (MobileAppCategoryCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IMobileAppCategoryCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (MobileAppCategoryCollectionRequest)this;
    }

    public IMobileAppCategoryCollectionPage buildFromResponse(final MobileAppCategoryCollectionResponse response) {
        final IMobileAppCategoryCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new MobileAppCategoryCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final MobileAppCategoryCollectionPage page = new MobileAppCategoryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
