// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceMobileAppConfigurationUserStatusRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationUserStatusRequest;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfigurationUserStatus;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Mobile App Configuration User Status Request.
 */
public class ManagedDeviceMobileAppConfigurationUserStatusRequest extends BaseRequest implements IManagedDeviceMobileAppConfigurationUserStatusRequest {
	
    /**
     * The request for the ManagedDeviceMobileAppConfigurationUserStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceMobileAppConfigurationUserStatusRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDeviceMobileAppConfigurationUserStatus.class);
    }

    /**
     * Gets the ManagedDeviceMobileAppConfigurationUserStatus from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<ManagedDeviceMobileAppConfigurationUserStatus> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ManagedDeviceMobileAppConfigurationUserStatus from the service
     *
     * @return the ManagedDeviceMobileAppConfigurationUserStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedDeviceMobileAppConfigurationUserStatus get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<ManagedDeviceMobileAppConfigurationUserStatus> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedDeviceMobileAppConfigurationUserStatus with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationUserStatus the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ManagedDeviceMobileAppConfigurationUserStatus sourceManagedDeviceMobileAppConfigurationUserStatus, final ICallback<ManagedDeviceMobileAppConfigurationUserStatus> callback) {
        send(HttpMethod.PATCH, callback, sourceManagedDeviceMobileAppConfigurationUserStatus);
    }

    /**
     * Patches this ManagedDeviceMobileAppConfigurationUserStatus with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationUserStatus the source object with updates
     * @return the updated ManagedDeviceMobileAppConfigurationUserStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedDeviceMobileAppConfigurationUserStatus patch(final ManagedDeviceMobileAppConfigurationUserStatus sourceManagedDeviceMobileAppConfigurationUserStatus) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedDeviceMobileAppConfigurationUserStatus);
    }

    /**
     * Creates a ManagedDeviceMobileAppConfigurationUserStatus with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationUserStatus the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ManagedDeviceMobileAppConfigurationUserStatus newManagedDeviceMobileAppConfigurationUserStatus, final ICallback<ManagedDeviceMobileAppConfigurationUserStatus> callback) {
        send(HttpMethod.POST, callback, newManagedDeviceMobileAppConfigurationUserStatus);
    }

    /**
     * Creates a ManagedDeviceMobileAppConfigurationUserStatus with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationUserStatus the new object to create
     * @return the created ManagedDeviceMobileAppConfigurationUserStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedDeviceMobileAppConfigurationUserStatus post(final ManagedDeviceMobileAppConfigurationUserStatus newManagedDeviceMobileAppConfigurationUserStatus) throws ClientException {
        return send(HttpMethod.POST, newManagedDeviceMobileAppConfigurationUserStatus);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IManagedDeviceMobileAppConfigurationUserStatusRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (ManagedDeviceMobileAppConfigurationUserStatusRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IManagedDeviceMobileAppConfigurationUserStatusRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (ManagedDeviceMobileAppConfigurationUserStatusRequest)this;
     }

}

