// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Token Lifetime Policy With Reference Request.
 */
public interface ITokenLifetimePolicyWithReferenceRequest extends IHttpRequest {

    void post(final TokenLifetimePolicy newTokenLifetimePolicy, final IJsonBackedObject payload, final ICallback<TokenLifetimePolicy> callback);

    TokenLifetimePolicy post(final TokenLifetimePolicy newTokenLifetimePolicy, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<TokenLifetimePolicy> callback);

    TokenLifetimePolicy get() throws ClientException;

	void delete(final ICallback<TokenLifetimePolicy> callback);

	void delete() throws ClientException;

	void patch(final TokenLifetimePolicy sourceTokenLifetimePolicy, final ICallback<TokenLifetimePolicy> callback);

	TokenLifetimePolicy patch(final TokenLifetimePolicy sourceTokenLifetimePolicy) throws ClientException;

    ITokenLifetimePolicyWithReferenceRequest select(final String value);

    ITokenLifetimePolicyWithReferenceRequest expand(final String value);

}
