// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Teams App Definition With Reference Request.
 */
public interface ITeamsAppDefinitionWithReferenceRequest extends IHttpRequest {

    void post(final TeamsAppDefinition newTeamsAppDefinition, final IJsonBackedObject payload, final ICallback<TeamsAppDefinition> callback);

    TeamsAppDefinition post(final TeamsAppDefinition newTeamsAppDefinition, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<TeamsAppDefinition> callback);

    TeamsAppDefinition get() throws ClientException;

	void delete(final ICallback<TeamsAppDefinition> callback);

	void delete() throws ClientException;

	void patch(final TeamsAppDefinition sourceTeamsAppDefinition, final ICallback<TeamsAppDefinition> callback);

	TeamsAppDefinition patch(final TeamsAppDefinition sourceTeamsAppDefinition) throws ClientException;

    ITeamsAppDefinitionWithReferenceRequest select(final String value);

    ITeamsAppDefinitionWithReferenceRequest expand(final String value);

}
