// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Collection Request.
 */
public class ChatMessageCollectionRequest extends BaseCollectionRequest<ChatMessageCollectionResponse, IChatMessageCollectionPage> implements IChatMessageCollectionRequest {

    /**
     * The request builder for this collection of ChatMessage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChatMessageCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatMessageCollectionResponse.class, IChatMessageCollectionPage.class);
    }

    public void get(final ICallback<IChatMessageCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IChatMessageCollectionPage get() throws ClientException {
        final ChatMessageCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ChatMessage newChatMessage, final ICallback<ChatMessage> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ChatMessageRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newChatMessage, callback);
    }

    public ChatMessage post(final ChatMessage newChatMessage) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ChatMessageRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newChatMessage);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IChatMessageCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ChatMessageCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IChatMessageCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ChatMessageCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IChatMessageCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ChatMessageCollectionRequest)this;
    }

    public IChatMessageCollectionPage buildFromResponse(final ChatMessageCollectionResponse response) {
        final IChatMessageCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ChatMessageCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ChatMessageCollectionPage page = new ChatMessageCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
