// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ICallKeepAliveRequest;
import com.microsoft.graph.requests.extensions.CallKeepAliveRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Keep Alive Request Builder.
 */
public class CallKeepAliveRequestBuilder extends BaseActionRequestBuilder implements ICallKeepAliveRequestBuilder {

    /**
     * The request builder for this CallKeepAlive
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallKeepAliveRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the ICallKeepAliveRequest
     *
     * @return the ICallKeepAliveRequest instance
     */
    public ICallKeepAliveRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the ICallKeepAliveRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ICallKeepAliveRequest instance
     */
    public ICallKeepAliveRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        CallKeepAliveRequest request = new CallKeepAliveRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
