// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ICalendarSharingMessageRequest;
import com.microsoft.graph.requests.extensions.CalendarSharingMessageRequest;
import com.microsoft.graph.requests.extensions.ICalendarSharingMessageAcceptRequestBuilder;
import com.microsoft.graph.requests.extensions.CalendarSharingMessageAcceptRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Sharing Message Request Builder.
 */
public class CalendarSharingMessageRequestBuilder extends BaseRequestBuilder implements ICalendarSharingMessageRequestBuilder {

    /**
     * The request builder for the CalendarSharingMessage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CalendarSharingMessageRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the ICalendarSharingMessageRequest instance
     */
    public ICalendarSharingMessageRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ICalendarSharingMessageRequest instance
     */
    public ICalendarSharingMessageRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new CalendarSharingMessageRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public ICalendarSharingMessageAcceptRequestBuilder accept() {
        return new CalendarSharingMessageAcceptRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.accept"), getClient(), null);
    }
}

