// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IActivityHistoryItemRequest;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemRequest;
import com.microsoft.graph.requests.extensions.IUserActivityWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.UserActivityWithReferenceRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Activity History Item Request Builder.
 */
public class ActivityHistoryItemRequestBuilder extends BaseRequestBuilder implements IActivityHistoryItemRequestBuilder {

    /**
     * The request builder for the ActivityHistoryItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ActivityHistoryItemRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IActivityHistoryItemRequest instance
     */
    public IActivityHistoryItemRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IActivityHistoryItemRequest instance
     */
    public IActivityHistoryItemRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ActivityHistoryItemRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for UserActivity
     *
     * @return the IUserActivityWithReferenceRequestBuilder instance
     */
    public IUserActivityWithReferenceRequestBuilder activity() {
        return new UserActivityWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("activity"), getClient(), null);
    }
}

