// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.ChatMessagePolicyViolationDlpActionTypes;
import com.microsoft.graph.models.extensions.ChatMessagePolicyViolationPolicyTip;
import com.microsoft.graph.models.generated.ChatMessagePolicyViolationUserActionTypes;
import com.microsoft.graph.models.generated.ChatMessagePolicyViolationVerdictDetailsTypes;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Policy Violation.
 */
public class ChatMessagePolicyViolation implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Dlp Action.
     * 
     */
    @SerializedName("dlpAction")
    @Expose
    public EnumSet<ChatMessagePolicyViolationDlpActionTypes> dlpAction;

    /**
     * The Justification Text.
     * 
     */
    @SerializedName("justificationText")
    @Expose
    public String justificationText;

    /**
     * The Policy Tip.
     * 
     */
    @SerializedName("policyTip")
    @Expose
    public ChatMessagePolicyViolationPolicyTip policyTip;

    /**
     * The User Action.
     * 
     */
    @SerializedName("userAction")
    @Expose
    public EnumSet<ChatMessagePolicyViolationUserActionTypes> userAction;

    /**
     * The Verdict Details.
     * 
     */
    @SerializedName("verdictDetails")
    @Expose
    public EnumSet<ChatMessagePolicyViolationVerdictDetailsTypes> verdictDetails;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
