/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Team;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamRequest;
import java.util.List;

public class TeamRequest
extends BaseRequest
implements ITeamRequest {
    public TeamRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Team.class);
    }

    @Override
    public void get(ICallback<Team> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Team get() throws ClientException {
        return (Team)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Team> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Team sourceTeam, ICallback<Team> callback) {
        this.send(HttpMethod.PATCH, callback, sourceTeam);
    }

    @Override
    public Team patch(Team sourceTeam) throws ClientException {
        return (Team)this.send(HttpMethod.PATCH, sourceTeam);
    }

    @Override
    public void post(Team newTeam, ICallback<Team> callback) {
        this.send(HttpMethod.POST, callback, newTeam);
    }

    @Override
    public Team post(Team newTeam) throws ClientException {
        return (Team)this.send(HttpMethod.POST, newTeam);
    }

    @Override
    public ITeamRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

