// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookChartRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartRequest;
import com.microsoft.graph.requests.extensions.IWorkbookChartAxesRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartAxesRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartDataLabelsRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartDataLabelsRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartAreaFormatRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartAreaFormatRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartLegendRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartLegendRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartSeriesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartSeriesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartSeriesRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartSeriesRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartTitleRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartTitleRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartSetDataRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartSetDataRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartSetPositionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartSetPositionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartImageRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartImageRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartImageRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartImageRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartImageRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartImageRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartImageRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartImageRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Request Builder.
 */
public class WorkbookChartRequestBuilder extends BaseRequestBuilder implements IWorkbookChartRequestBuilder {

    /**
     * The request builder for the WorkbookChart
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWorkbookChartRequest instance
     */
    public IWorkbookChartRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookChartRequest instance
     */
    public IWorkbookChartRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new WorkbookChartRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for WorkbookChartAxes
     *
     * @return the IWorkbookChartAxesRequestBuilder instance
     */
    public IWorkbookChartAxesRequestBuilder axes() {
        return new WorkbookChartAxesRequestBuilder(getRequestUrlWithAdditionalSegment("axes"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookChartDataLabels
     *
     * @return the IWorkbookChartDataLabelsRequestBuilder instance
     */
    public IWorkbookChartDataLabelsRequestBuilder dataLabels() {
        return new WorkbookChartDataLabelsRequestBuilder(getRequestUrlWithAdditionalSegment("dataLabels"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookChartAreaFormat
     *
     * @return the IWorkbookChartAreaFormatRequestBuilder instance
     */
    public IWorkbookChartAreaFormatRequestBuilder format() {
        return new WorkbookChartAreaFormatRequestBuilder(getRequestUrlWithAdditionalSegment("format"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookChartLegend
     *
     * @return the IWorkbookChartLegendRequestBuilder instance
     */
    public IWorkbookChartLegendRequestBuilder legend() {
        return new WorkbookChartLegendRequestBuilder(getRequestUrlWithAdditionalSegment("legend"), getClient(), null);
    }
    public IWorkbookChartSeriesCollectionRequestBuilder series() {
        return new WorkbookChartSeriesCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("series"), getClient(), null);
    }

    public IWorkbookChartSeriesRequestBuilder series(final String id) {
        return new WorkbookChartSeriesRequestBuilder(getRequestUrlWithAdditionalSegment("series") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookChartTitle
     *
     * @return the IWorkbookChartTitleRequestBuilder instance
     */
    public IWorkbookChartTitleRequestBuilder title() {
        return new WorkbookChartTitleRequestBuilder(getRequestUrlWithAdditionalSegment("title"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookWorksheet
     *
     * @return the IWorkbookWorksheetRequestBuilder instance
     */
    public IWorkbookWorksheetRequestBuilder worksheet() {
        return new WorkbookWorksheetRequestBuilder(getRequestUrlWithAdditionalSegment("worksheet"), getClient(), null);
    }

    public IWorkbookChartSetDataRequestBuilder setData(final com.google.gson.JsonElement sourceData, final String seriesBy) {
        return new WorkbookChartSetDataRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.setData"), getClient(), null, sourceData, seriesBy);
    }

    public IWorkbookChartSetPositionRequestBuilder setPosition(final com.google.gson.JsonElement startCell, final com.google.gson.JsonElement endCell) {
        return new WorkbookChartSetPositionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.setPosition"), getClient(), null, startCell, endCell);
    }

    public IWorkbookChartImageRequestBuilder image() {
        return new WorkbookChartImageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.image"), getClient(), null);
    }

    public IWorkbookChartImageRequestBuilder image(final Integer width) {
        return new WorkbookChartImageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.image"), getClient(), null, width);
    }

    public IWorkbookChartImageRequestBuilder image(final Integer width, final Integer height) {
        return new WorkbookChartImageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.image"), getClient(), null, width, height);
    }

    public IWorkbookChartImageRequestBuilder image(final Integer width, final Integer height, final String fittingMode) {
        return new WorkbookChartImageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.image"), getClient(), null, width, height, fittingMode);
    }
}

