// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Team Collection Request.
 */
public class TeamCollectionRequest extends BaseCollectionRequest<TeamCollectionResponse, ITeamCollectionPage> implements ITeamCollectionRequest {

    /**
     * The request builder for this collection of Team
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamCollectionResponse.class, ITeamCollectionPage.class);
    }

    public void get(final ICallback<ITeamCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ITeamCollectionPage get() throws ClientException {
        final TeamCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Team newTeam, final ICallback<Team> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new TeamRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTeam, callback);
    }

    public Team post(final Team newTeam) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new TeamRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTeam);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITeamCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (TeamCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITeamCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (TeamCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ITeamCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (TeamCollectionRequest)this;
    }

    public ITeamCollectionPage buildFromResponse(final TeamCollectionResponse response) {
        final ITeamCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new TeamCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final TeamCollectionPage page = new TeamCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
