// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Provider Collection Request.
 */
public class IdentityProviderCollectionRequest extends BaseCollectionRequest<IdentityProviderCollectionResponse, IIdentityProviderCollectionPage> implements IIdentityProviderCollectionRequest {

    /**
     * The request builder for this collection of IdentityProvider
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityProviderCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProviderCollectionResponse.class, IIdentityProviderCollectionPage.class);
    }

    public void get(final ICallback<IIdentityProviderCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IIdentityProviderCollectionPage get() throws ClientException {
        final IdentityProviderCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final IdentityProvider newIdentityProvider, final ICallback<IdentityProvider> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new IdentityProviderRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newIdentityProvider, callback);
    }

    public IdentityProvider post(final IdentityProvider newIdentityProvider) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new IdentityProviderRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newIdentityProvider);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IIdentityProviderCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (IdentityProviderCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IIdentityProviderCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (IdentityProviderCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IIdentityProviderCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (IdentityProviderCollectionRequest)this;
    }

    public IIdentityProviderCollectionPage buildFromResponse(final IdentityProviderCollectionResponse response) {
        final IIdentityProviderCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new IdentityProviderCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final IdentityProviderCollectionPage page = new IdentityProviderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
