/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookCommentReply;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookCommentReplyCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookCommentReplyCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookCommentReplyCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookCommentReplyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookCommentReplyCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookCommentReplyRequestBuilder;
import java.util.List;

public class WorkbookCommentReplyCollectionRequest
extends BaseCollectionRequest<WorkbookCommentReplyCollectionResponse, IWorkbookCommentReplyCollectionPage>
implements IWorkbookCommentReplyCollectionRequest {
    public WorkbookCommentReplyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookCommentReplyCollectionResponse.class, IWorkbookCommentReplyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookCommentReplyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookCommentReplyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookCommentReplyCollectionPage get() throws ClientException {
        WorkbookCommentReplyCollectionResponse response = (WorkbookCommentReplyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookCommentReply newWorkbookCommentReply, ICallback<WorkbookCommentReply> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookCommentReplyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookCommentReply, callback);
    }

    @Override
    public WorkbookCommentReply post(WorkbookCommentReply newWorkbookCommentReply) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookCommentReplyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookCommentReply);
    }

    @Override
    public IWorkbookCommentReplyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookCommentReplyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookCommentReplyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IWorkbookCommentReplyCollectionPage buildFromResponse(WorkbookCommentReplyCollectionResponse response) {
        WorkbookCommentReplyCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookCommentReplyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookCommentReplyCollectionPage page = new WorkbookCommentReplyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

