// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education User Reference Request.
 */
public class EducationUserReferenceRequest extends BaseRequest implements IEducationUserReferenceRequest {

    /**
     * The request for the EducationUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationUserReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationUser.class);
    }

    public void delete(final ICallback<EducationUser> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public EducationUser delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IEducationUserReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (EducationUserReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IEducationUserReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (EducationUserReferenceRequest)this;
    }
    /**
     * Puts the EducationUser
     *
     * @param srcEducationUser the EducationUser reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(EducationUser srcEducationUser, final ICallback<EducationUser> callback) {
        send(HttpMethod.PUT, callback, srcEducationUser);
    }

    /**
     * Puts the EducationUser
     *
     * @param srcEducationUser the EducationUser reference to PUT
     * @return the EducationUser
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public EducationUser put(EducationUser srcEducationUser) throws ClientException {
        return send(HttpMethod.PUT, srcEducationUser);
    }
}
