// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookFunctionsImConjugateRequest;
import com.microsoft.graph.requests.extensions.WorkbookFunctionsImConjugateRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Im Conjugate Request Builder.
 */
public class WorkbookFunctionsImConjugateRequestBuilder extends BaseActionRequestBuilder implements IWorkbookFunctionsImConjugateRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsImConjugate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param inumber the inumber
     */
    public WorkbookFunctionsImConjugateRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final com.google.gson.JsonElement inumber) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("inumber", inumber);
    }

    /**
     * Creates the IWorkbookFunctionsImConjugateRequest
     *
     * @return the IWorkbookFunctionsImConjugateRequest instance
     */
    public IWorkbookFunctionsImConjugateRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsImConjugateRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsImConjugateRequest instance
     */
    public IWorkbookFunctionsImConjugateRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        WorkbookFunctionsImConjugateRequest request = new WorkbookFunctionsImConjugateRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("inumber")) {
            request.body.inumber = getParameter("inumber");
        }

        return request;
    }
}
