// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IListItemVersionRequest;
import com.microsoft.graph.requests.extensions.ListItemVersionRequest;
import com.microsoft.graph.requests.extensions.IFieldValueSetRequestBuilder;
import com.microsoft.graph.requests.extensions.FieldValueSetRequestBuilder;
import com.microsoft.graph.requests.extensions.IListItemVersionRestoreVersionRequestBuilder;
import com.microsoft.graph.requests.extensions.ListItemVersionRestoreVersionRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the List Item Version Request Builder.
 */
public class ListItemVersionRequestBuilder extends BaseRequestBuilder implements IListItemVersionRequestBuilder {

    /**
     * The request builder for the ListItemVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ListItemVersionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IListItemVersionRequest instance
     */
    public IListItemVersionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IListItemVersionRequest instance
     */
    public IListItemVersionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ListItemVersionRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for FieldValueSet
     *
     * @return the IFieldValueSetRequestBuilder instance
     */
    public IFieldValueSetRequestBuilder fields() {
        return new FieldValueSetRequestBuilder(getRequestUrlWithAdditionalSegment("fields"), getClient(), null);
    }

    public IListItemVersionRestoreVersionRequestBuilder restoreVersion() {
        return new ListItemVersionRestoreVersionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.restoreVersion"), getClient(), null);
    }
}

