// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed Device Overview With Reference Request.
 */
public interface IManagedDeviceOverviewWithReferenceRequest extends IHttpRequest {

    void post(final ManagedDeviceOverview newManagedDeviceOverview, final IJsonBackedObject payload, final ICallback<ManagedDeviceOverview> callback);

    ManagedDeviceOverview post(final ManagedDeviceOverview newManagedDeviceOverview, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<ManagedDeviceOverview> callback);

    ManagedDeviceOverview get() throws ClientException;

	void delete(final ICallback<ManagedDeviceOverview> callback);

	void delete() throws ClientException;

	void patch(final ManagedDeviceOverview sourceManagedDeviceOverview, final ICallback<ManagedDeviceOverview> callback);

	ManagedDeviceOverview patch(final ManagedDeviceOverview sourceManagedDeviceOverview) throws ClientException;

    IManagedDeviceOverviewWithReferenceRequest select(final String value);

    IManagedDeviceOverviewWithReferenceRequest expand(final String value);

}
