// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Invitation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Invitation Request.
 */
public interface IInvitationRequest extends IHttpRequest {

    /**
     * Gets the Invitation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Invitation> callback);

    /**
     * Gets the Invitation from the service
     *
     * @return the Invitation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Invitation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Invitation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Invitation with a source
     *
     * @param sourceInvitation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Invitation sourceInvitation, final ICallback<Invitation> callback);

    /**
     * Patches this Invitation with a source
     *
     * @param sourceInvitation the source object with updates
     * @return the updated Invitation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Invitation patch(final Invitation sourceInvitation) throws ClientException;

    /**
     * Posts a Invitation with a new object
     *
     * @param newInvitation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Invitation newInvitation, final ICallback<Invitation> callback);

    /**
     * Posts a Invitation with a new object
     *
     * @param newInvitation the new object to create
     * @return the created Invitation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Invitation post(final Invitation newInvitation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IInvitationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IInvitationRequest expand(final String value);

}

