// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IEducationRootRequest;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationClassRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Education Root Request Builder.
 */
public interface IEducationRootRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IEducationRootRequest instance
     */
    IEducationRootRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IEducationRootRequest instance
     */
    IEducationRootRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IEducationClassCollectionRequestBuilder classes();

    IEducationClassRequestBuilder classes(final String id);

    IEducationSchoolCollectionRequestBuilder schools();

    IEducationSchoolRequestBuilder schools(final String id);

    IEducationUserCollectionRequestBuilder users();

    IEducationUserRequestBuilder users(final String id);

    /**
     * Gets the request builder for EducationUser
     *
     * @return the IEducationUserRequestBuilder instance
     */
    IEducationUserRequestBuilder me();

}
