// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationRequest;
import com.microsoft.graph.requests.extensions.DeviceConfigurationRequest;
import com.microsoft.graph.models.extensions.DeviceConfiguration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration Request.
 */
public class DeviceConfigurationRequest extends BaseRequest implements IDeviceConfigurationRequest {
	
    /**
     * The request for the DeviceConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public DeviceConfigurationRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends Option> requestOptions,
            final Class<? extends DeviceConfiguration> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the DeviceConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceConfigurationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfiguration.class);
    }

    /**
     * Gets the DeviceConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<DeviceConfiguration> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DeviceConfiguration from the service
     *
     * @return the DeviceConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<DeviceConfiguration> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceConfiguration with a source
     *
     * @param sourceDeviceConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final DeviceConfiguration sourceDeviceConfiguration, final ICallback<DeviceConfiguration> callback) {
        send(HttpMethod.PATCH, callback, sourceDeviceConfiguration);
    }

    /**
     * Patches this DeviceConfiguration with a source
     *
     * @param sourceDeviceConfiguration the source object with updates
     * @return the updated DeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceConfiguration patch(final DeviceConfiguration sourceDeviceConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceConfiguration);
    }

    /**
     * Creates a DeviceConfiguration with a new object
     *
     * @param newDeviceConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final DeviceConfiguration newDeviceConfiguration, final ICallback<DeviceConfiguration> callback) {
        send(HttpMethod.POST, callback, newDeviceConfiguration);
    }

    /**
     * Creates a DeviceConfiguration with a new object
     *
     * @param newDeviceConfiguration the new object to create
     * @return the created DeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceConfiguration post(final DeviceConfiguration newDeviceConfiguration) throws ClientException {
        return send(HttpMethod.POST, newDeviceConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDeviceConfigurationRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DeviceConfigurationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDeviceConfigurationRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DeviceConfigurationRequest)this;
     }

}

