/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.DefaultHttpProvider;
import com.microsoft.graph.http.GraphError;
import com.microsoft.graph.http.GraphErrorResponse;
import com.microsoft.graph.http.GraphFatalServiceException;
import com.microsoft.graph.http.GraphInnerError;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.logger.LoggerLevel;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.serializer.ISerializer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GraphServiceException
extends ClientException {
    private static final long serialVersionUID = -7416427229421064119L;
    protected static final char NEW_LINE = '\n';
    protected static final String TRUNCATION_MARKER = "[...]";
    protected static final int MAX_BREVITY_LENGTH = 50;
    protected static final int MAX_BYTE_COUNT_BEFORE_TRUNCATION = 8;
    public static final int INTERNAL_SERVER_ERROR = 500;
    private final transient GraphErrorResponse error;
    private final String method;
    private final String url;
    private final List<String> requestHeaders;
    private final String requestBody;
    private final int responseCode;
    private final String responseMessage;
    private final List<String> responseHeaders;
    private final boolean verbose;

    protected GraphServiceException(String method, String url, List<String> requestHeaders, String requestBody, int responseCode, String responseMessage, List<String> responseHeaders, GraphErrorResponse error, boolean verbose) {
        super(responseMessage, null);
        this.method = method;
        this.url = url;
        this.requestHeaders = requestHeaders;
        this.requestBody = requestBody;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.responseHeaders = responseHeaders;
        this.error = error;
        this.verbose = verbose;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public String getMessage() {
        return this.getMessage(this.verbose);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getMessage(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        if (this.error != null && this.error.error != null) {
            sb.append("Error code: ").append(this.error.error.code).append('\n');
            sb.append("Error message: ").append(this.error.error.message).append('\n');
            sb.append('\n');
        }
        sb.append(this.method).append(' ').append(this.url).append('\n');
        for (String header : this.requestHeaders) {
            if (verbose) {
                sb.append(header);
            } else {
                String truncatedHeader = header.substring(0, Math.min(50, header.length()));
                sb.append(truncatedHeader);
                if (truncatedHeader.length() == 50) {
                    sb.append(TRUNCATION_MARKER);
                }
            }
            sb.append('\n');
        }
        if (this.requestBody != null) {
            if (verbose) {
                sb.append(this.requestBody);
            } else {
                int bodyLength = Math.min(50, this.requestBody.length());
                String truncatedBody = this.requestBody.substring(0, bodyLength);
                sb.append(truncatedBody);
                if (truncatedBody.length() == 50) {
                    sb.append(TRUNCATION_MARKER);
                }
            }
        }
        sb.append('\n').append('\n');
        sb.append(this.responseCode).append(" : ").append(this.responseMessage).append('\n');
        for (String header : this.responseHeaders) {
            if (verbose) {
                sb.append(header).append('\n');
                continue;
            }
            if (!header.toLowerCase(Locale.ROOT).startsWith("x-throwsite")) continue;
            sb.append(header).append('\n');
        }
        if (verbose && this.error != null && this.error.rawObject != null) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                sb.append(gson.toJson((JsonElement)this.error.rawObject)).append('\n');
            }
            catch (RuntimeException ignored) {
                sb.append("[Warning: Unable to parse error message body]").append('\n');
            }
        } else if (!verbose) {
            sb.append(TRUNCATION_MARKER).append('\n').append('\n');
            sb.append("[Some information was truncated for brevity, enable debug logging for more details]");
        }
        return sb.toString();
    }

    public GraphError getServiceError() {
        return this.error.error;
    }

    public static <T> GraphServiceException createFromConnection(IHttpRequest request, T serializable, ISerializer serializer, IConnection connection, ILogger logger) throws IOException {
        GraphErrorResponse error;
        String requestBody;
        boolean isVerbose;
        String method = connection.getRequestMethod();
        String url = request.getRequestUrl().toString();
        LinkedList<String> requestHeaders = new LinkedList<String>();
        for (HeaderOption option : request.getHeaders()) {
            requestHeaders.add(option.getName() + " : " + option.getValue());
        }
        boolean bl = isVerbose = logger.getLoggingLevel() == LoggerLevel.DEBUG;
        if (serializable instanceof byte[]) {
            byte[] bytes = (byte[])serializable;
            StringBuilder sb = new StringBuilder();
            sb.append("byte[").append(bytes.length).append("]");
            sb.append(" {");
            if (isVerbose) {
                sb.append(bytes);
            } else {
                for (int i = 0; i < 8 && i < bytes.length; ++i) {
                    sb.append(bytes[i]).append(", ");
                }
                if (bytes.length > 8) {
                    sb.append(TRUNCATION_MARKER).append("}");
                }
            }
            requestBody = sb.toString();
        } else {
            requestBody = serializable != null ? serializer.serializeObject(serializable) : null;
        }
        int responseCode = connection.getResponseCode();
        LinkedList<String> responseHeaders = new LinkedList<String>();
        Map<String, String> headers = connection.getHeaders();
        for (String key : headers.keySet()) {
            String fieldPrefix = key == null ? "" : key + " : ";
            responseHeaders.add(fieldPrefix + headers.get(key));
        }
        String responseMessage = connection.getResponseMessage();
        String rawOutput = "{}";
        if (connection.getInputStream() != null) {
            rawOutput = DefaultHttpProvider.streamToString(connection.getInputStream());
        }
        try {
            error = serializer.deserializeObject(rawOutput, GraphErrorResponse.class, connection.getResponseHeaders());
        }
        catch (Exception ex) {
            error = new GraphErrorResponse();
            error.error = new GraphError();
            error.error.code = "Unable to parse error response message";
            error.error.message = "Raw error: " + rawOutput;
            error.error.innererror = new GraphInnerError();
            error.error.innererror.code = ex.getMessage();
        }
        if (responseCode >= 500) {
            return new GraphFatalServiceException(method, url, requestHeaders, requestBody, responseCode, responseMessage, responseHeaders, error, isVerbose);
        }
        return new GraphServiceException(method, url, requestHeaders, requestBody, responseCode, responseMessage, responseHeaders, error, isVerbose);
    }
}

