// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookRangeLastColumnRequest;
import com.microsoft.graph.requests.extensions.WorkbookRangeLastColumnRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Last Column Request Builder.
 */
public class WorkbookRangeLastColumnRequestBuilder extends BaseFunctionRequestBuilder implements IWorkbookRangeLastColumnRequestBuilder {

    /**
     * The request builder for this WorkbookRangeLastColumn
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRangeLastColumnRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IWorkbookRangeLastColumnRequest
     *
     * @return the IWorkbookRangeLastColumnRequest instance
     */
    public IWorkbookRangeLastColumnRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookRangeLastColumnRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookRangeLastColumnRequest instance
     */
    public IWorkbookRangeLastColumnRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        WorkbookRangeLastColumnRequest request = new WorkbookRangeLastColumnRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
