// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWindows10GeneralConfigurationRequest;
import com.microsoft.graph.requests.extensions.Windows10GeneralConfigurationRequest;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows10General Configuration Request Builder.
 */
public class Windows10GeneralConfigurationRequestBuilder extends BaseRequestBuilder implements IWindows10GeneralConfigurationRequestBuilder {

    /**
     * The request builder for the Windows10GeneralConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Windows10GeneralConfigurationRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWindows10GeneralConfigurationRequest instance
     */
    public IWindows10GeneralConfigurationRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWindows10GeneralConfigurationRequest instance
     */
    public IWindows10GeneralConfigurationRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new Windows10GeneralConfigurationRequest(getRequestUrl(), getClient(), requestOptions);
    }


}

