// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOnenotePageRequest;
import com.microsoft.graph.requests.extensions.IOnenoteSectionRequestBuilder;
import com.microsoft.graph.requests.extensions.INotebookRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnenotePageStreamRequestBuilder;
import com.microsoft.graph.models.extensions.OnenotePatchContentCommand;
import com.microsoft.graph.requests.extensions.IOnenotePageOnenotePatchContentRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnenotePageCopyToSectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnenotePagePreviewRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Onenote Page Request Builder.
 */
public interface IOnenotePageRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IOnenotePageRequest instance
     */
    IOnenotePageRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IOnenotePageRequest instance
     */
    IOnenotePageRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    /**
     * Gets the request builder for OnenoteSection
     *
     * @return the IOnenoteSectionRequestBuilder instance
     */
    IOnenoteSectionRequestBuilder parentSection();

    /**
     * Gets the request builder for Notebook
     *
     * @return the INotebookRequestBuilder instance
     */
    INotebookRequestBuilder parentNotebook();

    IOnenotePageStreamRequestBuilder content();
    IOnenotePageOnenotePatchContentRequestBuilder onenotePatchContent(final java.util.List<OnenotePatchContentCommand> commands);
    IOnenotePageCopyToSectionRequestBuilder copyToSection(final String id, final String groupId, final String siteCollectionId, final String siteId);
    IOnenotePagePreviewRequestBuilder preview();

}
