// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IItemActivityStatRequest;
import com.microsoft.graph.requests.extensions.IItemActivityCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IItemActivityRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Item Activity Stat Request Builder.
 */
public interface IItemActivityStatRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IItemActivityStatRequest instance
     */
    IItemActivityStatRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IItemActivityStatRequest instance
     */
    IItemActivityStatRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IItemActivityCollectionRequestBuilder activities();

    IItemActivityRequestBuilder activities(final String id);

}
