// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.StandardTimeZoneOffset;
import com.microsoft.graph.models.extensions.DaylightTimeZoneOffset;
import com.microsoft.graph.models.extensions.TimeZoneBase;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Time Zone.
 */
public class CustomTimeZone extends TimeZoneBase implements IJsonBackedObject {


    /**
     * The Bias.
     * The time offset of the time zone from Coordinated Universal Time (UTC). This value is in minutes. Time zones that are ahead of UTC have a positive offset; time zones that are behind UTC have a negative offset.
     */
    @SerializedName("bias")
    @Expose
    public Integer bias;

    /**
     * The Standard Offset.
     * Specifies when the time zone switches from daylight saving time to standard time.
     */
    @SerializedName("standardOffset")
    @Expose
    public StandardTimeZoneOffset standardOffset;

    /**
     * The Daylight Offset.
     * Specifies when the time zone switches from standard time to daylight saving time.
     */
    @SerializedName("daylightOffset")
    @Expose
    public DaylightTimeZoneOffset daylightOffset;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
