/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.BaseItem;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.IdentitySet;
import com.microsoft.graph.models.extensions.List;
import com.microsoft.graph.models.extensions.ListItem;
import com.microsoft.graph.models.extensions.Site;
import com.microsoft.graph.requests.extensions.DriveItemCollectionPage;
import com.microsoft.graph.requests.extensions.DriveItemCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class SharedDriveItem
extends BaseItem
implements IJsonBackedObject {
    @SerializedName(value="owner")
    @Expose
    public IdentitySet owner;
    @SerializedName(value="driveItem")
    @Expose
    public DriveItem driveItem;
    public DriveItemCollectionPage items;
    @SerializedName(value="list")
    @Expose
    public List list;
    @SerializedName(value="listItem")
    @Expose
    public ListItem listItem;
    @SerializedName(value="root")
    @Expose
    public DriveItem root;
    @SerializedName(value="site")
    @Expose
    public Site site;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("items")) {
            DriveItemCollectionResponse response = new DriveItemCollectionResponse();
            if (json.has("items@odata.nextLink")) {
                response.nextLink = json.get("items@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("items").toString(), JsonObject[].class);
            DriveItem[] array = new DriveItem[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DriveItem.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.items = new DriveItemCollectionPage(response, null);
        }
    }
}

