// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IUsedInsightRequest;
import com.microsoft.graph.requests.extensions.UsedInsightRequest;
import com.microsoft.graph.requests.extensions.IEntityWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.EntityWithReferenceRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Used Insight Request Builder.
 */
public class UsedInsightRequestBuilder extends BaseRequestBuilder implements IUsedInsightRequestBuilder {

    /**
     * The request builder for the UsedInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UsedInsightRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IUsedInsightRequest instance
     */
    public IUsedInsightRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IUsedInsightRequest instance
     */
    public IUsedInsightRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new UsedInsightRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for Entity
     *
     * @return the IEntityWithReferenceRequestBuilder instance
     */
    public IEntityWithReferenceRequestBuilder resource() {
        return new EntityWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("resource"), getClient(), null);
    }
}

