// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared Insight Collection Request.
 */
public class SharedInsightCollectionRequest extends BaseCollectionRequest<SharedInsightCollectionResponse, ISharedInsightCollectionPage> implements ISharedInsightCollectionRequest {

    /**
     * The request builder for this collection of SharedInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SharedInsightCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SharedInsightCollectionResponse.class, ISharedInsightCollectionPage.class);
    }

    public void get(final ICallback<ISharedInsightCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ISharedInsightCollectionPage get() throws ClientException {
        final SharedInsightCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final SharedInsight newSharedInsight, final ICallback<SharedInsight> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new SharedInsightRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSharedInsight, callback);
    }

    public SharedInsight post(final SharedInsight newSharedInsight) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new SharedInsightRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSharedInsight);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ISharedInsightCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (SharedInsightCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ISharedInsightCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (SharedInsightCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ISharedInsightCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (SharedInsightCollectionRequest)this;
    }

    public ISharedInsightCollectionPage buildFromResponse(final SharedInsightCollectionResponse response) {
        final ISharedInsightCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new SharedInsightCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final SharedInsightCollectionPage page = new SharedInsightCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
