// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceOverviewRequest;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceOverviewRequest;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Compliance Device Overview Request Builder.
 */
public class DeviceComplianceDeviceOverviewRequestBuilder extends BaseRequestBuilder implements IDeviceComplianceDeviceOverviewRequestBuilder {

    /**
     * The request builder for the DeviceComplianceDeviceOverview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceComplianceDeviceOverviewRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IDeviceComplianceDeviceOverviewRequest instance
     */
    public IDeviceComplianceDeviceOverviewRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IDeviceComplianceDeviceOverviewRequest instance
     */
    public IDeviceComplianceDeviceOverviewRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new DeviceComplianceDeviceOverviewRequest(getRequestUrl(), getClient(), requestOptions);
    }


}

