/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Trending;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITrendingCollectionPage;
import com.microsoft.graph.requests.extensions.ITrendingCollectionRequest;
import com.microsoft.graph.requests.extensions.TrendingCollectionPage;
import com.microsoft.graph.requests.extensions.TrendingCollectionRequest;
import com.microsoft.graph.requests.extensions.TrendingCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TrendingRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTrendingCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTrendingCollectionRequest;
import java.util.List;

public class BaseTrendingCollectionRequest
extends BaseCollectionRequest<BaseTrendingCollectionResponse, ITrendingCollectionPage>
implements IBaseTrendingCollectionRequest {
    public BaseTrendingCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTrendingCollectionResponse.class, ITrendingCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITrendingCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTrendingCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITrendingCollectionPage get() throws ClientException {
        BaseTrendingCollectionResponse response = (BaseTrendingCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Trending newTrending, ICallback<Trending> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TrendingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTrending, callback);
    }

    @Override
    public Trending post(Trending newTrending) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TrendingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTrending);
    }

    @Override
    public ITrendingCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TrendingCollectionRequest)this;
    }

    @Override
    public ITrendingCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TrendingCollectionRequest)this;
    }

    @Override
    public ITrendingCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TrendingCollectionRequest)this;
    }

    public ITrendingCollectionPage buildFromResponse(BaseTrendingCollectionResponse response) {
        TrendingCollectionRequestBuilder builder = response.nextLink != null ? new TrendingCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TrendingCollectionPage page = new TrendingCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

