/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.RoleAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRoleAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IRoleAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.RoleAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.RoleAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.RoleAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.RoleAssignmentRequestBuilder;
import com.microsoft.graph.requests.generated.BaseRoleAssignmentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseRoleAssignmentCollectionRequest;
import java.util.List;

public class BaseRoleAssignmentCollectionRequest
extends BaseCollectionRequest<BaseRoleAssignmentCollectionResponse, IRoleAssignmentCollectionPage>
implements IBaseRoleAssignmentCollectionRequest {
    public BaseRoleAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseRoleAssignmentCollectionResponse.class, IRoleAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRoleAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseRoleAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRoleAssignmentCollectionPage get() throws ClientException {
        BaseRoleAssignmentCollectionResponse response = (BaseRoleAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(RoleAssignment newRoleAssignment, ICallback<RoleAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new RoleAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRoleAssignment, callback);
    }

    @Override
    public RoleAssignment post(RoleAssignment newRoleAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RoleAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRoleAssignment);
    }

    @Override
    public IRoleAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (RoleAssignmentCollectionRequest)this;
    }

    @Override
    public IRoleAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (RoleAssignmentCollectionRequest)this;
    }

    @Override
    public IRoleAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (RoleAssignmentCollectionRequest)this;
    }

    public IRoleAssignmentCollectionPage buildFromResponse(BaseRoleAssignmentCollectionResponse response) {
        RoleAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new RoleAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RoleAssignmentCollectionPage page = new RoleAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

