/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ResourceOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IResourceOperationCollectionPage;
import com.microsoft.graph.requests.extensions.IResourceOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.ResourceOperationCollectionPage;
import com.microsoft.graph.requests.extensions.ResourceOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.ResourceOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ResourceOperationRequestBuilder;
import com.microsoft.graph.requests.generated.BaseResourceOperationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseResourceOperationCollectionRequest;
import java.util.List;

public class BaseResourceOperationCollectionRequest
extends BaseCollectionRequest<BaseResourceOperationCollectionResponse, IResourceOperationCollectionPage>
implements IBaseResourceOperationCollectionRequest {
    public BaseResourceOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseResourceOperationCollectionResponse.class, IResourceOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IResourceOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseResourceOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IResourceOperationCollectionPage get() throws ClientException {
        BaseResourceOperationCollectionResponse response = (BaseResourceOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ResourceOperation newResourceOperation, ICallback<ResourceOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ResourceOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newResourceOperation, callback);
    }

    @Override
    public ResourceOperation post(ResourceOperation newResourceOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ResourceOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newResourceOperation);
    }

    @Override
    public IResourceOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ResourceOperationCollectionRequest)this;
    }

    @Override
    public IResourceOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ResourceOperationCollectionRequest)this;
    }

    @Override
    public IResourceOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ResourceOperationCollectionRequest)this;
    }

    public IResourceOperationCollectionPage buildFromResponse(BaseResourceOperationCollectionResponse response) {
        ResourceOperationCollectionRequestBuilder builder = response.nextLink != null ? new ResourceOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ResourceOperationCollectionPage page = new ResourceOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

